function Bits = Eight_PSK_Demodulation(symbol_input)

N=length(symbol_input);
Bits = [];

% The for-loop picks out each current symbol
for k=1:N;
    
    % Finding out the angle of the current symbol
    tmp_segment = angle(symbol_input(k));
    
    
    % Here the angle is used to find out the symbols placement on the unit circle
    % The placement of the symbol is then converted to bits
    
    % The mapping is gray coded
    
    if tmp_segment>= (-pi/8) && tmp_segment<= ((pi/8)+0*(pi/4))  
        
       tmp_bits = [0 0 0];
        
    elseif tmp_segment>= ((pi/8)+0*(pi/4)) && tmp_segment<= ((pi/8)+1*(pi/4))
        
         tmp_bits = [ 0 0 1 ];
        
    elseif tmp_segment>= ((pi/8)+1*(pi/4)) && tmp_segment<= ((pi/8)+2*(pi/4))
        
       tmp_bits = [0 1 1];
       
    elseif tmp_segment>= ((pi/8)+2*(pi/4)) && tmp_segment<= ((pi/8)+3*(pi/4))
        
        tmp_bits = [0 1 0];
       
    elseif tmp_segment>= pi-(pi/8) && tmp_segment <= pi ||tmp_segment>= -pi && tmp_segment<= (-(pi/8)-3*(pi/4))
        
        tmp_bits = [1 1 0];
    elseif tmp_segment>= (-(pi/8)-3*(pi/4)) && tmp_segment<= (-(pi/8)-2*(pi/4))
        
        tmp_bits = [1 1 1];
        
    elseif tmp_segment>= (-(pi/8)-2*(pi/4)) && tmp_segment<= (-(pi/8)-1*(pi/4))
        
        tmp_bits = [1 0 1];
        
    elseif tmp_segment>= (-(pi/8)-1*(pi/4)) && tmp_segment<= (-(pi/8)-0*(pi/4))    
        
        tmp_bits = [1 0 0];
    end
    
    % Collecting the bits for each current symbol in an output vector
    Bits = [Bits, tmp_bits];
    
end

end

